/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8273.RsBoxConfig;
import ibm.nways.jdm8273.RsModule;
import ibm.nways.jdm8273.RsPort;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.TextArea;

public class RsTestBoxConfig
extends DestinationPropBook {
    private RsTestConfigSection section1;
    private RsTestGraphicSection section2;
    private RsBoxConfig chassisConfig;

    RsBoxConfig getChassisConfig() {
        return this.chassisConfig;
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return new String("Test Config Panel");
    }

    public void addSections() {
        this.section1 = new RsTestConfigSection(this);
        this.section2 = new RsTestGraphicSection(this);
        this.addSection("Box Config", this.section1);
        this.addSection("Box Graphic", this.section2);
        this.chassisConfig = new RsBoxConfig((GenModel)this.getModel());
        this.section1.refresh();
        this.section2.refresh();
    }

    class RsTestConfigSection
    extends PropertySection {
        private DestinationPropBook parentBook;
        private TextArea ta;

        public RsTestConfigSection(DestinationPropBook destinationPropBook) {
            RsTestBoxConfig.this = RsTestBoxConfig.this;
            this.parentBook = destinationPropBook;
            this.setLayout(new BorderLayout());
            this.ta = new TextArea("Getting Config ...", 30, 40);
            this.add("Center", this.ta);
        }

        public void refresh() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Chassis Type: " + RsTestBoxConfig.this.getChassisConfig().getChasType() + "\n");
            stringBuffer.append("Number of Slots: " + RsTestBoxConfig.this.getChassisConfig().getNumOfSlots() + "\n");
            int n = 0;
            while (n < RsTestBoxConfig.this.getChassisConfig().getNumOfSlots()) {
                RsModule rsModule = RsTestBoxConfig.this.getChassisConfig().getModuleAt(n);
                stringBuffer.append("Slot " + rsModule.getSlotNum() + " Type: " + rsModule.getSlotType() + "\n");
                stringBuffer.append("Slot " + rsModule.getSlotNum() + " Media Type" + rsModule.getPortMediaType() + "\n");
                stringBuffer.append("Slot " + rsModule.getSlotNum() + " Number of Subunits: " + rsModule.getNumOfSubUnits() + "\n");
                int n2 = 0;
                while (n2 < rsModule.getNumOfSubUnits()) {
                    int n3 = rsModule.getSubUnitTypeAt(n2);
                    int n4 = rsModule.getSubUnitPosOf(n2);
                    stringBuffer.append("  SubUnit " + n2 + " Pos: " + n4 + " Media Type: " + n3 + "\n");
                    ++n2;
                }
                stringBuffer.append("Slot " + rsModule.getSlotNum() + " Number of Ports: " + rsModule.getNumOfPorts() + "\n");
                int n5 = 0;
                while (n5 < rsModule.getNumOfPorts()) {
                    RsPort rsPort = rsModule.getPortAt(n5);
                    stringBuffer.append("  Port " + rsPort.getPortNum() + " Type: " + rsPort.getPortType() + "\n");
                    ++n5;
                }
                ++n;
            }
            this.ta.setText(stringBuffer.toString());
        }
    }

    class RsTestGraphicSection
    extends PropertySection {
        private DestinationPropBook parentBook;
        private TextArea ta;

        public RsTestGraphicSection(DestinationPropBook destinationPropBook) {
            RsTestBoxConfig.this = RsTestBoxConfig.this;
            this.parentBook = destinationPropBook;
            this.setLayout(new BorderLayout());
            this.ta = new TextArea("Getting Graphic ...", 30, 40);
            this.add("Center", this.ta);
        }

        public void refresh() {
            String string;
            RsPort rsPort;
            int n;
            RsModule rsModule;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            if (RsTestBoxConfig.this.getChassisConfig().is8273mod100()) {
                stringBuffer.append("Front Panel:  8273 Model 100 Backplane \n");
                rsModule = RsTestBoxConfig.this.getChassisConfig().getModuleWithNum(2);
                n = 0;
                while (n < rsModule.getNumOfPorts()) {
                    rsPort = rsModule.getPortAt(n);
                    switch (rsPort.getPortType()) {
                        case 5: {
                            string = "Ethernet RJ-45";
                            break;
                        }
                        default: {
                            string = "Unrecognized";
                        }
                    }
                    stringBuffer.append("  Port " + rsPort.getPortNum() + ": " + string + "\n");
                    ++n;
                }
            } else if (RsTestBoxConfig.this.getChassisConfig().is8273mod10u()) {
                stringBuffer.append("Front Panel:  8273 Model 10U Backplane \n");
                rsModule = RsTestBoxConfig.this.getChassisConfig().getModuleWithNum(2);
                n = 0;
                while (n < rsModule.getNumOfPorts()) {
                    rsPort = rsModule.getPortAt(n);
                    switch (rsPort.getPortType()) {
                        case 5: {
                            string = "eth utp -> RJ-45 ";
                            break;
                        }
                        case 7: {
                            string = "eth aui -> AUI";
                            break;
                        }
                        case 8: {
                            string = "eth bnc -> BNC";
                            break;
                        }
                        case 9: {
                            string = "eth fiorl -> eth Fiber Connector";
                            break;
                        }
                        case 23: {
                            string = "fdx aui -> AUI";
                            break;
                        }
                        case 24: {
                            string = "fdx aui2 -> AUI";
                            break;
                        }
                        default: {
                            string = "Unrecognized";
                        }
                    }
                    stringBuffer.append("  Port " + rsPort.getPortNum() + ": " + string + "\n");
                    ++n;
                }
            } else {
                stringBuffer.append("Unrecognized model \n");
            }
            if (RsTestBoxConfig.this.getChassisConfig().getListOfModules() == null) {
                bl = false;
            }
            int[] nArray = new int[]{3, 3};
            RsPort[] rsPortArray = new RsPort[]{null, null};
            if (bl) {
                rsModule = RsTestBoxConfig.this.getChassisConfig().getModuleWithNum(3);
                int n2 = rsModule.getNumOfSubUnits();
                int n3 = 0;
                while (n3 < n2) {
                    switch (rsModule.getSubUnitPosOf(n3)) {
                        case 2: {
                            nArray[0] = rsModule.getSubUnitTypeAt(n3);
                            rsPortArray[0] = rsModule.getPortAt(n3);
                            break;
                        }
                        case 3: {
                            nArray[1] = rsModule.getSubUnitTypeAt(n3);
                            rsPortArray[1] = rsModule.getPortAt(n3);
                            break;
                        }
                    }
                    ++n3;
                }
                if (rsPortArray[1] == null && (rsModule = RsTestBoxConfig.this.getChassisConfig().getModuleWithNum(4)) != null) {
                    nArray[1] = rsModule.getSubUnitTypeAt(0);
                    rsPortArray[1] = rsModule.getPortAt(0);
                }
                String string2 = null;
                int n4 = 0;
                while (n4 < 2) {
                    if (rsPortArray[n4] == null) {
                        stringBuffer.append("Uplink " + n4 + ":  Empty\n");
                    } else {
                        switch (nArray[n4]) {
                            case 12: 
                            case 18: 
                            case 23: 
                            case 24: {
                                string2 = "ATM";
                                break;
                            }
                            case 11: {
                                string2 = "Fast Ethernet";
                                break;
                            }
                            case 9: 
                            case 17: {
                                string2 = "FDDI";
                                break;
                            }
                            case 10: {
                                string2 = "CDDI";
                                break;
                            }
                            default: {
                                string2 = "Unknown";
                            }
                        }
                        stringBuffer.append("Uplink " + n4 + ": " + string2 + "\n");
                        stringBuffer.append("  Slot " + rsPortArray[n4].getSlotNum() + "  Port " + rsPortArray[n4].getPortNum() + "\n");
                    }
                    ++n4;
                }
            }
            this.ta.setText(stringBuffer.toString());
        }
    }
}

